#include<bits/stdc++.h>
using namespace std;

const int maxn = 1e6;
int N, d[maxn];
vector< pair<int, int> > e, nodes;
map<int, int> m;

// We assign to nodes, IDs from 1 to N 
int get_node(int v)
{
  if(!m[v])
    {
      N ++;
      m[v] = N;
    }
  return m[v];
}

int main(int argc, char** argv)
{
  srand(12345);
  // Get cardinality constraint and sliding window length from system argument
  int K = atoi(argv[1]);
  int W = atoi(argv[2]);
  // Read input of SNAP network
  // Line 1-4 of SNAP network are comments, so we skip them
  for(int i = 0; i < 4; i ++)
    {
      string tmp;
      getline(cin, tmp);
    }
  // Read edges
  int v, u;
  while(cin >> v >> u)
    {
      v = get_node(v);
      u = get_node(u);
      d[v] --;
      d[u] --;
      e.push_back(make_pair(v, u));
    }
  // Print edges
  cout<< e.size() << " " << 2 * N + 1 << " " << K << endl;
  for(int i = 0; i < e.size(); i ++)
    cout<< e[i].first << " " << e[i].second << endl;
  // Randomly add nodes and remove them after W insertions
  for(int i = 1; i <= N; i ++)
    nodes.push_back(make_pair(d[i], i));
  sort(nodes.begin(), nodes.end());
  for(int i = 0; i < N + W - 1; i ++)
    {
      if(i < N)
        cout << nodes[i].second << endl;
      if(i >= W)
        cout << - nodes[i - W].second << endl;
    }
}
